/*=============================================================================}
{ Demo of basic using of hypertext                                             }
{ In this demo were modified styles: RVStyle1->TextStyles>[4] and              }
{ RVStyle->TextStyles->Items[5]                                                }
{ Setting RVStyle->TextStyles->Items[i].Jump to True turns this text style into}
{ hypertext style.                                                             }
{ Properties of text styles affecting hypertext appearance:                    }
{ - HoverColor (color of hypertext under mouse (clNone for not changing)       }
{ - HoverBackColor (color of hypertext background under mouse (clNone for      }
{   transparent)                                                               }
{ - JumpCursor                                                                 }
{------------------------------------------------------------------------------}
{ Key events and properties:                                                   }
{ - OnJump, OnRVMouseMove                                                      }
{ - FirstJumpNo                                                                }
{=============================================================================*/
#include <vcl\vcl.h>
#pragma hdrstop

#include "Unit1.h"
//---------------------------------------------------------------------------
#pragma link "RichView"
#pragma link "RVScroll"
#pragma link "RVStyle"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
  // RVStyle1->TextStyles->Items[4].Jump == RVStyle1->TextStyles->Items[5].Jump == True
  // This causes these styles to represent hypertext
  RichView1->AddNLATag("Hypertext",1,1,0);
  RichView1->AddNLATag("Some text styles can be chosen as hypertext styles. ",0,0,0);
  RichView1->AddNLATag("Like this one.",4,-1,0);
  RichView1->AddNLATag(" You can have as many hypertext styles as you want.  ",0,-1,0);
  RichView1->AddNLATag("Here is one more.",5,-1,0);
  RichView1->Format();

  /*
    The basic method to use hypertext is "hypertext IDs".
    All hypertext jumps are numbered sequentially (0,1,...) from top of
    document to bottom. These numbers are called "hypertext IDs".
    Hypertext id is passed in OnJump and OnRVMouseMove events.

    More correct, jumps are numbered as FirstJumpNo, FirstJumpNo+1,
    FirstJumpNo+2,...
    FirstJumpNo is a property of RichView, 0 by default
  */
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RichView1Jump(TObject *Sender, int id)
{
  Panel1->Caption = AnsiString("Clicked: ")+IntToStr(id);    
}
//---------------------------------------------------------------------------
void __fastcall TForm1::RichView1RVMouseMove(TObject *Sender, int id)
{
  // id==-1 when mouse leaves hypertext jump area
  if (id!=-1)
    Label1->Caption = IntToStr(id);
  else
    Label1->Caption = "---";
}
//---------------------------------------------------------------------------
